/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.Set;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.elements.FullyQualifiedElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public abstract class PhpElementImpl
implements PhpElement {
    private static final String CLUSTER_URL = "cluster:";
    private static String clusterUrl = null;
    private final String name;
    private final String in;
    private final String fileUrl;
    private final int offset;
    private final ElementQuery elementQuery;
    private FileObject fileObject;
    private final boolean isDeprecated;

    public static PhpElementImpl create(String variableName, String in, int offset, final FileObject fo, final PhpElementKind kind) {
        return new PhpElementImpl(variableName, in, null, offset, null, false){

            @Override
            public String getSignature() {
                return "";
            }

            @Override
            public PhpElementKind getPhpElementKind() {
                return kind;
            }

            @Override
            public synchronized FileObject getFileObject() {
                return fo;
            }
        };
    }

    PhpElementImpl(String name, String in, String fileUrl, int offset, ElementQuery elementQuery, boolean isDeprecated) {
        this.name = name;
        this.in = in;
        this.fileUrl = fileUrl == null ? "" : fileUrl;
        this.offset = offset;
        if (fileUrl != null && fileUrl.contains(" ")) {
            throw new IllegalArgumentException("fileURL may not contain spaces!");
        }
        this.elementQuery = elementQuery;
        this.isDeprecated = isDeprecated;
    }

    @Override
    public final String getFilenameUrl() {
        return this.fileUrl;
    }

    @Override
    public PhpModifiers getPhpModifiers() {
        return PhpModifiers.noModifiers();
    }

    @Override
    public final int getOffset() {
        return this.offset;
    }

    public final Set<Modifier> getModifiers() {
        return this.getPhpModifiers().toModifiers();
    }

    public OffsetRange getOffsetRange(ParserResult result) {
        return new OffsetRange(this.offset, this.offset + this.getName().length());
    }

    @Override
    public ElementQuery getElementQuery() {
        return this.elementQuery;
    }

    public synchronized FileObject getFileObject() {
        String urlStr = this.fileUrl;
        if (this.fileObject == null && StringUtils.hasText((String)this.fileUrl)) {
            this.fileObject = PhpElementImpl.resolveFileObject(urlStr);
        }
        return this.fileObject;
    }

    public synchronized void setFileObject(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    public static FileObject resolveFileObject(String urlStr) {
        Object url = urlStr;
        if (((String)url).startsWith(CLUSTER_URL)) {
            clusterUrl = PhpElementImpl.getClusterUrl();
            url = clusterUrl + ((String)url).substring(CLUSTER_URL.length());
        }
        return PhpElementImpl.toFileObject((String)url);
    }

    public static FileObject toFileObject(String urlStr) {
        try {
            URL url = new URL(urlStr);
            return URLMapper.findFileObject((URL)url);
        }
        catch (MalformedURLException mue) {
            Exceptions.printStackTrace((Throwable)mue);
            return null;
        }
    }

    private static String getClusterUrl() {
        String retval = null;
        if (retval == null) {
            File f = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-php-editor.jar", null, false);
            if (f == null) {
                throw new RuntimeException("Can't find cluster");
            }
            f = new File(f.getParentFile().getParentFile().getAbsolutePath());
            try {
                f = f.getCanonicalFile();
                retval = Utilities.toURI((File)f).toURL().toExternalForm();
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return retval;
    }

    public final String getName() {
        return this.name;
    }

    public final String getIn() {
        return this.in;
    }

    public abstract String getSignature();

    public final boolean signatureEquals(ElementHandle handle) {
        if (handle instanceof PhpElementImpl) {
            PhpElementImpl other = (PhpElementImpl)handle;
            return this.getSignature().equals(other.getSignature());
        }
        return false;
    }

    @Override
    public final boolean isPlatform() {
        FileObject fo = this.getFileObject();
        if (fo != null) {
            PhpSourcePath.FileType fileType = PhpSourcePath.getFileType((FileObject)fo);
            return fileType.equals((Object)PhpSourcePath.FileType.INTERNAL);
        }
        return false;
    }

    @Override
    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public final String getMimeType() {
        return "text/x-php5";
    }

    @Override
    public final int getFlags() {
        return this.getPhpModifiers().toFlags();
    }

    public final ElementKind getKind() {
        return this.getPhpElementKind().getElementKind();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PhpElementImpl other = (PhpElementImpl)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.in == null ? other.in != null : !this.in.equals(other.in)) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        return !(this.fileUrl == null ? other.fileUrl != null : !this.fileUrl.equals(other.fileUrl));
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 71 * hash + (this.in != null ? this.in.hashCode() : 0);
        hash = 71 * hash + (this.fileUrl != null ? this.fileUrl.hashCode() : 0);
        hash = 71 * hash + this.offset;
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPhpElementKind().toString()).append(" ");
        if (this instanceof FullyQualifiedElement) {
            sb.append(((FullyQualifiedElement)((Object)this)).getFullyQualifiedName().toString());
        } else {
            sb.append(this.getName());
        }
        return sb.toString();
    }

    static enum Separator {
        SEMICOLON(";"),
        COMMA(","),
        COLON(":"),
        PIPE("|");

        private final String value;

        public static EnumSet<Separator> toEnumSet() {
            return EnumSet.allOf(Separator.class);
        }

        private Separator(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

